#version 460

uniform samplerCube tex_cm;
uniform float alpha;
uniform bool dotFlag;

in vec3 n;
in vec3 incident;

out vec4 color;

void main() {

    vec3 nn = normalize(n);
    vec3 i = normalize(incident);

    vec3 refl = reflect(i, nn);

    float opacity = alpha;
    if (dotFlag) 
		  opacity = 1 - dot(-i,n);


    color = vec4(texture(tex_cm, refl).rgb, opacity);
}
